package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class FindingCriteria(
    criterion: Option[
      Map[__string, zio.aws.macie2.model.CriterionAdditionalProperties]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.FindingCriteria = {
    import FindingCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.FindingCriteria
      .builder()
      .optionallyWith(
        criterion.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.criterion)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.FindingCriteria.ReadOnly =
    zio.aws.macie2.model.FindingCriteria.wrap(buildAwsValue())
}
object FindingCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.FindingCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.FindingCriteria =
      zio.aws.macie2.model.FindingCriteria(
        criterion.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def criterion: Option[
      Map[__string, zio.aws.macie2.model.CriterionAdditionalProperties.ReadOnly]
    ]
    def getCriterion: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.macie2.model.CriterionAdditionalProperties.ReadOnly
    ]] = AwsError.unwrapOptionField("criterion", criterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.FindingCriteria
  ) extends zio.aws.macie2.model.FindingCriteria.ReadOnly {
    override val criterion: Option[
      Map[__string, zio.aws.macie2.model.CriterionAdditionalProperties.ReadOnly]
    ] = scala
      .Option(impl.criterion())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.macie2.model.CriterionAdditionalProperties
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.FindingCriteria
  ): zio.aws.macie2.model.FindingCriteria.ReadOnly = new Wrapper(impl)
}
