package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DomainDetails(domainName: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DomainDetails = {
    import DomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DomainDetails
      .builder()
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DomainDetails.ReadOnly =
    zio.aws.macie2.model.DomainDetails.wrap(buildAwsValue())
}
object DomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DomainDetails =
      zio.aws.macie2.model.DomainDetails(domainName.map(value => value))
    def domainName: Option[__string]
    def getDomainName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DomainDetails
  ) extends zio.aws.macie2.model.DomainDetails.ReadOnly {
    override val domainName: Option[__string] =
      scala.Option(impl.domainName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DomainDetails
  ): zio.aws.macie2.model.DomainDetails.ReadOnly = new Wrapper(impl)
}
