package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BucketLevelPermissions(
    accessControlList: Option[zio.aws.macie2.model.AccessControlList] = None,
    blockPublicAccess: Option[zio.aws.macie2.model.BlockPublicAccess] = None,
    bucketPolicy: Option[zio.aws.macie2.model.BucketPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketLevelPermissions = {
    import BucketLevelPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
      .builder()
      .optionallyWith(accessControlList.map(value => value.buildAwsValue()))(
        _.accessControlList
      )
      .optionallyWith(blockPublicAccess.map(value => value.buildAwsValue()))(
        _.blockPublicAccess
      )
      .optionallyWith(bucketPolicy.map(value => value.buildAwsValue()))(
        _.bucketPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketLevelPermissions.ReadOnly =
    zio.aws.macie2.model.BucketLevelPermissions.wrap(buildAwsValue())
}
object BucketLevelPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketLevelPermissions =
      zio.aws.macie2.model.BucketLevelPermissions(
        accessControlList.map(value => value.asEditable),
        blockPublicAccess.map(value => value.asEditable),
        bucketPolicy.map(value => value.asEditable)
      )
    def accessControlList
        : Option[zio.aws.macie2.model.AccessControlList.ReadOnly]
    def blockPublicAccess
        : Option[zio.aws.macie2.model.BlockPublicAccess.ReadOnly]
    def bucketPolicy: Option[zio.aws.macie2.model.BucketPolicy.ReadOnly]
    def getAccessControlList
        : ZIO[Any, AwsError, zio.aws.macie2.model.AccessControlList.ReadOnly] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getBlockPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BlockPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("blockPublicAccess", blockPublicAccess)
    def getBucketPolicy
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketPolicy.ReadOnly] =
      AwsError.unwrapOptionField("bucketPolicy", bucketPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
  ) extends zio.aws.macie2.model.BucketLevelPermissions.ReadOnly {
    override val accessControlList
        : Option[zio.aws.macie2.model.AccessControlList.ReadOnly] = scala
      .Option(impl.accessControlList())
      .map(value => zio.aws.macie2.model.AccessControlList.wrap(value))
    override val blockPublicAccess
        : Option[zio.aws.macie2.model.BlockPublicAccess.ReadOnly] = scala
      .Option(impl.blockPublicAccess())
      .map(value => zio.aws.macie2.model.BlockPublicAccess.wrap(value))
    override val bucketPolicy
        : Option[zio.aws.macie2.model.BucketPolicy.ReadOnly] = scala
      .Option(impl.bucketPolicy())
      .map(value => zio.aws.macie2.model.BucketPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
  ): zio.aws.macie2.model.BucketLevelPermissions.ReadOnly = new Wrapper(impl)
}
