package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__integer
import scala.jdk.CollectionConverters._
final case class TestCustomDataIdentifierResponse(
    matchCount: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse = {
    import TestCustomDataIdentifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse
      .builder()
      .optionallyWith(matchCount.map(value => value: Integer))(_.matchCount)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly =
    zio.aws.macie2.model.TestCustomDataIdentifierResponse.wrap(buildAwsValue())
}
object TestCustomDataIdentifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TestCustomDataIdentifierResponse =
      zio.aws.macie2.model
        .TestCustomDataIdentifierResponse(matchCount.map(value => value))
    def matchCount: Option[__integer]
    def getMatchCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("matchCount", matchCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse
  ) extends zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly {
    override val matchCount: Option[__integer] =
      scala.Option(impl.matchCount()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse
  ): zio.aws.macie2.model.TestCustomDataIdentifierResponse.ReadOnly =
    new Wrapper(impl)
}
