package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters._
final case class Range(
    end: Option[__long] = None,
    start: Option[__long] = None,
    startColumn: Option[__long] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Range
      .builder()
      .optionallyWith(end.map(value => value: java.lang.Long))(_.end)
      .optionallyWith(start.map(value => value: java.lang.Long))(_.start)
      .optionallyWith(startColumn.map(value => value: java.lang.Long))(
        _.startColumn
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Range.ReadOnly =
    zio.aws.macie2.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Range = zio.aws.macie2.model.Range(
      end.map(value => value),
      start.map(value => value),
      startColumn.map(value => value)
    )
    def end: Option[__long]
    def start: Option[__long]
    def startColumn: Option[__long]
    def getEnd: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("end", end)
    def getStart: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("start", start)
    def getStartColumn: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("startColumn", startColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Range
  ) extends zio.aws.macie2.model.Range.ReadOnly {
    override val end: Option[__long] =
      scala.Option(impl.end()).map(value => value: __long)
    override val start: Option[__long] =
      scala.Option(impl.start()).map(value => value: __long)
    override val startColumn: Option[__long] =
      scala.Option(impl.startColumn()).map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Range
  ): zio.aws.macie2.model.Range.ReadOnly = new Wrapper(impl)
}
