package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobScheduleFrequency(
    dailySchedule: Option[zio.aws.macie2.model.DailySchedule] = None,
    monthlySchedule: Option[zio.aws.macie2.model.MonthlySchedule] = None,
    weeklySchedule: Option[zio.aws.macie2.model.WeeklySchedule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobScheduleFrequency = {
    import JobScheduleFrequency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
      .builder()
      .optionallyWith(dailySchedule.map(value => value.buildAwsValue()))(
        _.dailySchedule
      )
      .optionallyWith(monthlySchedule.map(value => value.buildAwsValue()))(
        _.monthlySchedule
      )
      .optionallyWith(weeklySchedule.map(value => value.buildAwsValue()))(
        _.weeklySchedule
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobScheduleFrequency.ReadOnly =
    zio.aws.macie2.model.JobScheduleFrequency.wrap(buildAwsValue())
}
object JobScheduleFrequency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobScheduleFrequency =
      zio.aws.macie2.model.JobScheduleFrequency(
        dailySchedule.map(value => value.asEditable),
        monthlySchedule.map(value => value.asEditable),
        weeklySchedule.map(value => value.asEditable)
      )
    def dailySchedule: Option[zio.aws.macie2.model.DailySchedule.ReadOnly]
    def monthlySchedule: Option[zio.aws.macie2.model.MonthlySchedule.ReadOnly]
    def weeklySchedule: Option[zio.aws.macie2.model.WeeklySchedule.ReadOnly]
    def getDailySchedule
        : ZIO[Any, AwsError, zio.aws.macie2.model.DailySchedule.ReadOnly] =
      AwsError.unwrapOptionField("dailySchedule", dailySchedule)
    def getMonthlySchedule
        : ZIO[Any, AwsError, zio.aws.macie2.model.MonthlySchedule.ReadOnly] =
      AwsError.unwrapOptionField("monthlySchedule", monthlySchedule)
    def getWeeklySchedule
        : ZIO[Any, AwsError, zio.aws.macie2.model.WeeklySchedule.ReadOnly] =
      AwsError.unwrapOptionField("weeklySchedule", weeklySchedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
  ) extends zio.aws.macie2.model.JobScheduleFrequency.ReadOnly {
    override val dailySchedule
        : Option[zio.aws.macie2.model.DailySchedule.ReadOnly] = scala
      .Option(impl.dailySchedule())
      .map(value => zio.aws.macie2.model.DailySchedule.wrap(value))
    override val monthlySchedule
        : Option[zio.aws.macie2.model.MonthlySchedule.ReadOnly] = scala
      .Option(impl.monthlySchedule())
      .map(value => zio.aws.macie2.model.MonthlySchedule.wrap(value))
    override val weeklySchedule
        : Option[zio.aws.macie2.model.WeeklySchedule.ReadOnly] = scala
      .Option(impl.weeklySchedule())
      .map(value => zio.aws.macie2.model.WeeklySchedule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobScheduleFrequency
  ): zio.aws.macie2.model.JobScheduleFrequency.ReadOnly = new Wrapper(impl)
}
