package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class IpOwner(
    asn: Option[__string] = None,
    asnOrg: Option[__string] = None,
    isp: Option[__string] = None,
    org: Option[__string] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.IpOwner = {
    import IpOwner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpOwner
      .builder()
      .optionallyWith(asn.map(value => value: java.lang.String))(_.asn)
      .optionallyWith(asnOrg.map(value => value: java.lang.String))(_.asnOrg)
      .optionallyWith(isp.map(value => value: java.lang.String))(_.isp)
      .optionallyWith(org.map(value => value: java.lang.String))(_.org)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpOwner.ReadOnly =
    zio.aws.macie2.model.IpOwner.wrap(buildAwsValue())
}
object IpOwner {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.IpOwner] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpOwner = zio.aws.macie2.model.IpOwner(
      asn.map(value => value),
      asnOrg.map(value => value),
      isp.map(value => value),
      org.map(value => value)
    )
    def asn: Option[__string]
    def asnOrg: Option[__string]
    def isp: Option[__string]
    def org: Option[__string]
    def getAsn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("asn", asn)
    def getAsnOrg: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("asnOrg", asnOrg)
    def getIsp: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("isp", isp)
    def getOrg: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("org", org)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpOwner
  ) extends zio.aws.macie2.model.IpOwner.ReadOnly {
    override val asn: Option[__string] =
      scala.Option(impl.asn()).map(value => value: __string)
    override val asnOrg: Option[__string] =
      scala.Option(impl.asnOrg()).map(value => value: __string)
    override val isp: Option[__string] =
      scala.Option(impl.isp()).map(value => value: __string)
    override val org: Option[__string] =
      scala.Option(impl.org()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpOwner
  ): zio.aws.macie2.model.IpOwner.ReadOnly = new Wrapper(impl)
}
