package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class IpAddressDetails(
    ipAddressV4: Option[__string] = None,
    ipCity: Option[zio.aws.macie2.model.IpCity] = None,
    ipCountry: Option[zio.aws.macie2.model.IpCountry] = None,
    ipGeoLocation: Option[zio.aws.macie2.model.IpGeoLocation] = None,
    ipOwner: Option[zio.aws.macie2.model.IpOwner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.IpAddressDetails = {
    import IpAddressDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpAddressDetails
      .builder()
      .optionallyWith(ipAddressV4.map(value => value: java.lang.String))(
        _.ipAddressV4
      )
      .optionallyWith(ipCity.map(value => value.buildAwsValue()))(_.ipCity)
      .optionallyWith(ipCountry.map(value => value.buildAwsValue()))(
        _.ipCountry
      )
      .optionallyWith(ipGeoLocation.map(value => value.buildAwsValue()))(
        _.ipGeoLocation
      )
      .optionallyWith(ipOwner.map(value => value.buildAwsValue()))(_.ipOwner)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpAddressDetails.ReadOnly =
    zio.aws.macie2.model.IpAddressDetails.wrap(buildAwsValue())
}
object IpAddressDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.IpAddressDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpAddressDetails =
      zio.aws.macie2.model.IpAddressDetails(
        ipAddressV4.map(value => value),
        ipCity.map(value => value.asEditable),
        ipCountry.map(value => value.asEditable),
        ipGeoLocation.map(value => value.asEditable),
        ipOwner.map(value => value.asEditable)
      )
    def ipAddressV4: Option[__string]
    def ipCity: Option[zio.aws.macie2.model.IpCity.ReadOnly]
    def ipCountry: Option[zio.aws.macie2.model.IpCountry.ReadOnly]
    def ipGeoLocation: Option[zio.aws.macie2.model.IpGeoLocation.ReadOnly]
    def ipOwner: Option[zio.aws.macie2.model.IpOwner.ReadOnly]
    def getIpAddressV4: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
    def getIpCity: ZIO[Any, AwsError, zio.aws.macie2.model.IpCity.ReadOnly] =
      AwsError.unwrapOptionField("ipCity", ipCity)
    def getIpCountry
        : ZIO[Any, AwsError, zio.aws.macie2.model.IpCountry.ReadOnly] =
      AwsError.unwrapOptionField("ipCountry", ipCountry)
    def getIpGeoLocation
        : ZIO[Any, AwsError, zio.aws.macie2.model.IpGeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("ipGeoLocation", ipGeoLocation)
    def getIpOwner: ZIO[Any, AwsError, zio.aws.macie2.model.IpOwner.ReadOnly] =
      AwsError.unwrapOptionField("ipOwner", ipOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpAddressDetails
  ) extends zio.aws.macie2.model.IpAddressDetails.ReadOnly {
    override val ipAddressV4: Option[__string] =
      scala.Option(impl.ipAddressV4()).map(value => value: __string)
    override val ipCity: Option[zio.aws.macie2.model.IpCity.ReadOnly] = scala
      .Option(impl.ipCity())
      .map(value => zio.aws.macie2.model.IpCity.wrap(value))
    override val ipCountry: Option[zio.aws.macie2.model.IpCountry.ReadOnly] =
      scala
        .Option(impl.ipCountry())
        .map(value => zio.aws.macie2.model.IpCountry.wrap(value))
    override val ipGeoLocation
        : Option[zio.aws.macie2.model.IpGeoLocation.ReadOnly] = scala
      .Option(impl.ipGeoLocation())
      .map(value => zio.aws.macie2.model.IpGeoLocation.wrap(value))
    override val ipOwner: Option[zio.aws.macie2.model.IpOwner.ReadOnly] = scala
      .Option(impl.ipOwner())
      .map(value => zio.aws.macie2.model.IpOwner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpAddressDetails
  ): zio.aws.macie2.model.IpAddressDetails.ReadOnly = new Wrapper(impl)
}
