package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ApiCallDetails(
    api: Option[__string] = None,
    apiServiceName: Option[__string] = None,
    firstSeen: Option[__timestampIso8601] = None,
    lastSeen: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ApiCallDetails = {
    import ApiCallDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ApiCallDetails
      .builder()
      .optionallyWith(api.map(value => value: java.lang.String))(_.api)
      .optionallyWith(apiServiceName.map(value => value: java.lang.String))(
        _.apiServiceName
      )
      .optionallyWith(firstSeen.map(value => value: Instant))(_.firstSeen)
      .optionallyWith(lastSeen.map(value => value: Instant))(_.lastSeen)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ApiCallDetails.ReadOnly =
    zio.aws.macie2.model.ApiCallDetails.wrap(buildAwsValue())
}
object ApiCallDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ApiCallDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ApiCallDetails =
      zio.aws.macie2.model.ApiCallDetails(
        api.map(value => value),
        apiServiceName.map(value => value),
        firstSeen.map(value => value),
        lastSeen.map(value => value)
      )
    def api: Option[__string]
    def apiServiceName: Option[__string]
    def firstSeen: Option[__timestampIso8601]
    def lastSeen: Option[__timestampIso8601]
    def getApi: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("api", api)
    def getApiServiceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiServiceName", apiServiceName)
    def getFirstSeen: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("firstSeen", firstSeen)
    def getLastSeen: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastSeen", lastSeen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ApiCallDetails
  ) extends zio.aws.macie2.model.ApiCallDetails.ReadOnly {
    override val api: Option[__string] =
      scala.Option(impl.api()).map(value => value: __string)
    override val apiServiceName: Option[__string] =
      scala.Option(impl.apiServiceName()).map(value => value: __string)
    override val firstSeen: Option[__timestampIso8601] =
      scala.Option(impl.firstSeen()).map(value => value: __timestampIso8601)
    override val lastSeen: Option[__timestampIso8601] =
      scala.Option(impl.lastSeen()).map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ApiCallDetails
  ): zio.aws.macie2.model.ApiCallDetails.ReadOnly = new Wrapper(impl)
}
