package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__double
import scala.jdk.CollectionConverters._
final case class IpGeoLocation(
    lat: Option[__double] = None,
    lon: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.IpGeoLocation = {
    import IpGeoLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpGeoLocation
      .builder()
      .optionallyWith(
        lat.map(value => __double.unwrap(value): java.lang.Double)
      )(_.lat)
      .optionallyWith(
        lon.map(value => __double.unwrap(value): java.lang.Double)
      )(_.lon)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpGeoLocation.ReadOnly =
    zio.aws.macie2.model.IpGeoLocation.wrap(buildAwsValue())
}
object IpGeoLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.IpGeoLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpGeoLocation = zio.aws.macie2.model
      .IpGeoLocation(lat.map(value => value), lon.map(value => value))
    def lat: Option[__double]
    def lon: Option[__double]
    def getLat: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("lat", lat)
    def getLon: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("lon", lon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpGeoLocation
  ) extends zio.aws.macie2.model.IpGeoLocation.ReadOnly {
    override val lat: Option[__double] = scala
      .Option(impl.lat())
      .map(value => zio.aws.macie2.model.primitives.__double(value))
    override val lon: Option[__double] = scala
      .Option(impl.lon())
      .map(value => zio.aws.macie2.model.primitives.__double(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpGeoLocation
  ): zio.aws.macie2.model.IpGeoLocation.ReadOnly = new Wrapper(impl)
}
