package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  __timestampIso8601,
  __long,
  __boolean,
  __string
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Finding(
    accountId: Option[__string] = None,
    archived: Option[__boolean] = None,
    category: Option[zio.aws.macie2.model.FindingCategory] = None,
    classificationDetails: Option[zio.aws.macie2.model.ClassificationDetails] =
      None,
    count: Option[__long] = None,
    createdAt: Option[__timestampIso8601] = None,
    description: Option[__string] = None,
    id: Option[__string] = None,
    partition: Option[__string] = None,
    policyDetails: Option[zio.aws.macie2.model.PolicyDetails] = None,
    region: Option[__string] = None,
    resourcesAffected: Option[zio.aws.macie2.model.ResourcesAffected] = None,
    sample: Option[__boolean] = None,
    schemaVersion: Option[__string] = None,
    severity: Option[zio.aws.macie2.model.Severity] = None,
    title: Option[__string] = None,
    `type`: Option[zio.aws.macie2.model.FindingType] = None,
    updatedAt: Option[__timestampIso8601] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Finding
      .builder()
      .optionallyWith(
        accountId.map(value => __string.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        archived.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.archived)
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        classificationDetails.map(value => value.buildAwsValue())
      )(_.classificationDetails)
      .optionallyWith(count.map(value => __long.unwrap(value): java.lang.Long))(
        _.count
      )
      .optionallyWith(
        createdAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        partition.map(value => __string.unwrap(value): java.lang.String)
      )(_.partition)
      .optionallyWith(policyDetails.map(value => value.buildAwsValue()))(
        _.policyDetails
      )
      .optionallyWith(
        region.map(value => __string.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(resourcesAffected.map(value => value.buildAwsValue()))(
        _.resourcesAffected
      )
      .optionallyWith(
        sample.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.sample)
      .optionallyWith(
        schemaVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.schemaVersion)
      .optionallyWith(severity.map(value => value.buildAwsValue()))(_.severity)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        updatedAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Finding.ReadOnly =
    zio.aws.macie2.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Finding] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Finding = zio.aws.macie2.model.Finding(
      accountId.map(value => value),
      archived.map(value => value),
      category.map(value => value),
      classificationDetails.map(value => value.asEditable),
      count.map(value => value),
      createdAt.map(value => value),
      description.map(value => value),
      id.map(value => value),
      partition.map(value => value),
      policyDetails.map(value => value.asEditable),
      region.map(value => value),
      resourcesAffected.map(value => value.asEditable),
      sample.map(value => value),
      schemaVersion.map(value => value),
      severity.map(value => value.asEditable),
      title.map(value => value),
      `type`.map(value => value),
      updatedAt.map(value => value)
    )
    def accountId: Option[__string]
    def archived: Option[__boolean]
    def category: Option[zio.aws.macie2.model.FindingCategory]
    def classificationDetails
        : Option[zio.aws.macie2.model.ClassificationDetails.ReadOnly]
    def count: Option[__long]
    def createdAt: Option[__timestampIso8601]
    def description: Option[__string]
    def id: Option[__string]
    def partition: Option[__string]
    def policyDetails: Option[zio.aws.macie2.model.PolicyDetails.ReadOnly]
    def region: Option[__string]
    def resourcesAffected
        : Option[zio.aws.macie2.model.ResourcesAffected.ReadOnly]
    def sample: Option[__boolean]
    def schemaVersion: Option[__string]
    def severity: Option[zio.aws.macie2.model.Severity.ReadOnly]
    def title: Option[__string]
    def `type`: Option[zio.aws.macie2.model.FindingType]
    def updatedAt: Option[__timestampIso8601]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("archived", archived)
    def getCategory: ZIO[Any, AwsError, zio.aws.macie2.model.FindingCategory] =
      AwsError.unwrapOptionField("category", category)
    def getClassificationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("classificationDetails", classificationDetails)
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getPartition: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("partition", partition)
    def getPolicyDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.PolicyDetails.ReadOnly] =
      AwsError.unwrapOptionField("policyDetails", policyDetails)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
    def getResourcesAffected
        : ZIO[Any, AwsError, zio.aws.macie2.model.ResourcesAffected.ReadOnly] =
      AwsError.unwrapOptionField("resourcesAffected", resourcesAffected)
    def getSample: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("sample", sample)
    def getSchemaVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.macie2.model.Severity.ReadOnly] =
      AwsError.unwrapOptionField("severity", severity)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.FindingType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Finding
  ) extends zio.aws.macie2.model.Finding.ReadOnly {
    override val accountId: Option[__string] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val archived: Option[__boolean] = scala
      .Option(impl.archived())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val category: Option[zio.aws.macie2.model.FindingCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.macie2.model.FindingCategory.wrap(value))
    override val classificationDetails
        : Option[zio.aws.macie2.model.ClassificationDetails.ReadOnly] = scala
      .Option(impl.classificationDetails())
      .map(value => zio.aws.macie2.model.ClassificationDetails.wrap(value))
    override val count: Option[__long] = scala
      .Option(impl.count())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val createdAt: Option[__timestampIso8601] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val partition: Option[__string] = scala
      .Option(impl.partition())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val policyDetails
        : Option[zio.aws.macie2.model.PolicyDetails.ReadOnly] = scala
      .Option(impl.policyDetails())
      .map(value => zio.aws.macie2.model.PolicyDetails.wrap(value))
    override val region: Option[__string] = scala
      .Option(impl.region())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val resourcesAffected
        : Option[zio.aws.macie2.model.ResourcesAffected.ReadOnly] = scala
      .Option(impl.resourcesAffected())
      .map(value => zio.aws.macie2.model.ResourcesAffected.wrap(value))
    override val sample: Option[__boolean] = scala
      .Option(impl.sample())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val schemaVersion: Option[__string] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val severity: Option[zio.aws.macie2.model.Severity.ReadOnly] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.macie2.model.Severity.wrap(value))
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val `type`: Option[zio.aws.macie2.model.FindingType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.FindingType.wrap(value))
    override val updatedAt: Option[__timestampIso8601] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Finding
  ): zio.aws.macie2.model.Finding.ReadOnly = new Wrapper(impl)
}
