package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __long}
import scala.jdk.CollectionConverters._
final case class DefaultDetection(
    count: Option[__long] = None,
    occurrences: Option[zio.aws.macie2.model.Occurrences] = None,
    `type`: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DefaultDetection = {
    import DefaultDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DefaultDetection
      .builder()
      .optionallyWith(count.map(value => __long.unwrap(value): java.lang.Long))(
        _.count
      )
      .optionallyWith(occurrences.map(value => value.buildAwsValue()))(
        _.occurrences
      )
      .optionallyWith(
        `type`.map(value => __string.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DefaultDetection.ReadOnly =
    zio.aws.macie2.model.DefaultDetection.wrap(buildAwsValue())
}
object DefaultDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DefaultDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DefaultDetection =
      zio.aws.macie2.model.DefaultDetection(
        count.map(value => value),
        occurrences.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def count: Option[__long]
    def occurrences: Option[zio.aws.macie2.model.Occurrences.ReadOnly]
    def `type`: Option[__string]
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getOccurrences
        : ZIO[Any, AwsError, zio.aws.macie2.model.Occurrences.ReadOnly] =
      AwsError.unwrapOptionField("occurrences", occurrences)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DefaultDetection
  ) extends zio.aws.macie2.model.DefaultDetection.ReadOnly {
    override val count: Option[__long] = scala
      .Option(impl.count())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val occurrences
        : Option[zio.aws.macie2.model.Occurrences.ReadOnly] = scala
      .Option(impl.occurrences())
      .map(value => zio.aws.macie2.model.Occurrences.wrap(value))
    override val `type`: Option[__string] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DefaultDetection
  ): zio.aws.macie2.model.DefaultDetection.ReadOnly = new Wrapper(impl)
}
