package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetUsageTotalsResponse(
    timeRange: Option[zio.aws.macie2.model.TimeRange] = None,
    usageTotals: Option[Iterable[zio.aws.macie2.model.UsageTotal]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse = {
    import GetUsageTotalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
      .builder()
      .optionallyWith(timeRange.map(value => value.unwrap))(_.timeRange)
      .optionallyWith(
        usageTotals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageTotals)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly =
    zio.aws.macie2.model.GetUsageTotalsResponse.wrap(buildAwsValue())
}
object GetUsageTotalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetUsageTotalsResponse =
      zio.aws.macie2.model.GetUsageTotalsResponse(
        timeRange.map(value => value),
        usageTotals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def timeRange: Option[zio.aws.macie2.model.TimeRange]
    def usageTotals: Option[List[zio.aws.macie2.model.UsageTotal.ReadOnly]]
    def getTimeRange: ZIO[Any, AwsError, zio.aws.macie2.model.TimeRange] =
      AwsError.unwrapOptionField("timeRange", timeRange)
    def getUsageTotals
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.UsageTotal.ReadOnly]] =
      AwsError.unwrapOptionField("usageTotals", usageTotals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
  ) extends zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly {
    override val timeRange: Option[zio.aws.macie2.model.TimeRange] = scala
      .Option(impl.timeRange())
      .map(value => zio.aws.macie2.model.TimeRange.wrap(value))
    override val usageTotals
        : Option[List[zio.aws.macie2.model.UsageTotal.ReadOnly]] = scala
      .Option(impl.usageTotals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.UsageTotal.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
  ): zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly = new Wrapper(impl)
}
