package zio.aws.macie2.model
import java.time.Instant
import zio.aws.macie2.model.primitives.{
  __integer,
  __boolean,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClassificationJobResponse(
    clientToken: Option[__string] = None,
    createdAt: Option[__timestampIso8601] = None,
    customDataIdentifierIds: Option[Iterable[__string]] = None,
    description: Option[__string] = None,
    initialRun: Option[__boolean] = None,
    jobArn: Option[__string] = None,
    jobId: Option[__string] = None,
    jobStatus: Option[zio.aws.macie2.model.JobStatus] = None,
    jobType: Option[zio.aws.macie2.model.JobType] = None,
    lastRunErrorStatus: Option[zio.aws.macie2.model.LastRunErrorStatus] = None,
    lastRunTime: Option[__timestampIso8601] = None,
    managedDataIdentifierIds: Option[Iterable[__string]] = None,
    managedDataIdentifierSelector: Option[
      zio.aws.macie2.model.ManagedDataIdentifierSelector
    ] = None,
    name: Option[__string] = None,
    s3JobDefinition: Option[zio.aws.macie2.model.S3JobDefinition] = None,
    samplingPercentage: Option[__integer] = None,
    scheduleFrequency: Option[zio.aws.macie2.model.JobScheduleFrequency] = None,
    statistics: Option[zio.aws.macie2.model.Statistics] = None,
    tags: Option[Map[__string, __string]] = None,
    userPausedDetails: Option[zio.aws.macie2.model.UserPausedDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse = {
    import DescribeClassificationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
      .builder()
      .optionallyWith(
        clientToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        createdAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        customDataIdentifierIds.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customDataIdentifierIds)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        initialRun.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.initialRun)
      .optionallyWith(
        jobArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobId.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(lastRunErrorStatus.map(value => value.buildAwsValue()))(
        _.lastRunErrorStatus
      )
      .optionallyWith(
        lastRunTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.lastRunTime)
      .optionallyWith(
        managedDataIdentifierIds.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.managedDataIdentifierIds)
      .optionallyWith(managedDataIdentifierSelector.map(value => value.unwrap))(
        _.managedDataIdentifierSelector
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(s3JobDefinition.map(value => value.buildAwsValue()))(
        _.s3JobDefinition
      )
      .optionallyWith(
        samplingPercentage.map(value => __integer.unwrap(value): Integer)
      )(_.samplingPercentage)
      .optionallyWith(scheduleFrequency.map(value => value.buildAwsValue()))(
        _.scheduleFrequency
      )
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(userPausedDetails.map(value => value.buildAwsValue()))(
        _.userPausedDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly =
    zio.aws.macie2.model.DescribeClassificationJobResponse.wrap(buildAwsValue())
}
object DescribeClassificationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DescribeClassificationJobResponse =
      zio.aws.macie2.model.DescribeClassificationJobResponse(
        clientToken.map(value => value),
        createdAt.map(value => value),
        customDataIdentifierIds.map(value => value),
        description.map(value => value),
        initialRun.map(value => value),
        jobArn.map(value => value),
        jobId.map(value => value),
        jobStatus.map(value => value),
        jobType.map(value => value),
        lastRunErrorStatus.map(value => value.asEditable),
        lastRunTime.map(value => value),
        managedDataIdentifierIds.map(value => value),
        managedDataIdentifierSelector.map(value => value),
        name.map(value => value),
        s3JobDefinition.map(value => value.asEditable),
        samplingPercentage.map(value => value),
        scheduleFrequency.map(value => value.asEditable),
        statistics.map(value => value.asEditable),
        tags.map(value => value),
        userPausedDetails.map(value => value.asEditable)
      )
    def clientToken: Option[__string]
    def createdAt: Option[__timestampIso8601]
    def customDataIdentifierIds: Option[List[__string]]
    def description: Option[__string]
    def initialRun: Option[__boolean]
    def jobArn: Option[__string]
    def jobId: Option[__string]
    def jobStatus: Option[zio.aws.macie2.model.JobStatus]
    def jobType: Option[zio.aws.macie2.model.JobType]
    def lastRunErrorStatus
        : Option[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly]
    def lastRunTime: Option[__timestampIso8601]
    def managedDataIdentifierIds: Option[List[__string]]
    def managedDataIdentifierSelector
        : Option[zio.aws.macie2.model.ManagedDataIdentifierSelector]
    def name: Option[__string]
    def s3JobDefinition: Option[zio.aws.macie2.model.S3JobDefinition.ReadOnly]
    def samplingPercentage: Option[__integer]
    def scheduleFrequency
        : Option[zio.aws.macie2.model.JobScheduleFrequency.ReadOnly]
    def statistics: Option[zio.aws.macie2.model.Statistics.ReadOnly]
    def tags: Option[Map[__string, __string]]
    def userPausedDetails
        : Option[zio.aws.macie2.model.UserPausedDetails.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCustomDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "customDataIdentifierIds",
        customDataIdentifierIds
      )
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getInitialRun: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("initialRun", initialRun)
    def getJobArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.macie2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getJobType: ZIO[Any, AwsError, zio.aws.macie2.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getLastRunErrorStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] =
      AwsError.unwrapOptionField("lastRunErrorStatus", lastRunErrorStatus)
    def getLastRunTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastRunTime", lastRunTime)
    def getManagedDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "managedDataIdentifierIds",
        managedDataIdentifierIds
      )
    def getManagedDataIdentifierSelector: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ManagedDataIdentifierSelector
    ] = AwsError.unwrapOptionField(
      "managedDataIdentifierSelector",
      managedDataIdentifierSelector
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getS3JobDefinition
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3JobDefinition.ReadOnly] =
      AwsError.unwrapOptionField("s3JobDefinition", s3JobDefinition)
    def getSamplingPercentage: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("samplingPercentage", samplingPercentage)
    def getScheduleFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.JobScheduleFrequency.ReadOnly
    ] = AwsError.unwrapOptionField("scheduleFrequency", scheduleFrequency)
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.macie2.model.Statistics.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserPausedDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserPausedDetails.ReadOnly] =
      AwsError.unwrapOptionField("userPausedDetails", userPausedDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
  ) extends zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly {
    override val clientToken: Option[__string] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val createdAt: Option[__timestampIso8601] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val customDataIdentifierIds: Option[List[__string]] = scala
      .Option(impl.customDataIdentifierIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val initialRun: Option[__boolean] = scala
      .Option(impl.initialRun())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val jobArn: Option[__string] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val jobId: Option[__string] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val jobStatus: Option[zio.aws.macie2.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.macie2.model.JobStatus.wrap(value))
    override val jobType: Option[zio.aws.macie2.model.JobType] = scala
      .Option(impl.jobType())
      .map(value => zio.aws.macie2.model.JobType.wrap(value))
    override val lastRunErrorStatus
        : Option[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] = scala
      .Option(impl.lastRunErrorStatus())
      .map(value => zio.aws.macie2.model.LastRunErrorStatus.wrap(value))
    override val lastRunTime: Option[__timestampIso8601] = scala
      .Option(impl.lastRunTime())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val managedDataIdentifierIds: Option[List[__string]] = scala
      .Option(impl.managedDataIdentifierIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val managedDataIdentifierSelector
        : Option[zio.aws.macie2.model.ManagedDataIdentifierSelector] = scala
      .Option(impl.managedDataIdentifierSelector())
      .map(value =>
        zio.aws.macie2.model.ManagedDataIdentifierSelector.wrap(value)
      )
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val s3JobDefinition
        : Option[zio.aws.macie2.model.S3JobDefinition.ReadOnly] = scala
      .Option(impl.s3JobDefinition())
      .map(value => zio.aws.macie2.model.S3JobDefinition.wrap(value))
    override val samplingPercentage: Option[__integer] = scala
      .Option(impl.samplingPercentage())
      .map(value => zio.aws.macie2.model.primitives.__integer(value))
    override val scheduleFrequency
        : Option[zio.aws.macie2.model.JobScheduleFrequency.ReadOnly] = scala
      .Option(impl.scheduleFrequency())
      .map(value => zio.aws.macie2.model.JobScheduleFrequency.wrap(value))
    override val statistics: Option[zio.aws.macie2.model.Statistics.ReadOnly] =
      scala
        .Option(impl.statistics())
        .map(value => zio.aws.macie2.model.Statistics.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives
              .__string(key) -> zio.aws.macie2.model.primitives.__string(value)
          })
          .toMap
      )
    override val userPausedDetails
        : Option[zio.aws.macie2.model.UserPausedDetails.ReadOnly] = scala
      .Option(impl.userPausedDetails())
      .map(value => zio.aws.macie2.model.UserPausedDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse
  ): zio.aws.macie2.model.DescribeClassificationJobResponse.ReadOnly =
    new Wrapper(impl)
}
