package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResourceProfileDetectionsRequest(
    resourceArn: __string,
    suppressDataIdentifiers: Optional[
      Iterable[zio.aws.macie2.model.SuppressDataIdentifier]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsRequest = {
    import UpdateResourceProfileDetectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .optionallyWith(
        suppressDataIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suppressDataIdentifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateResourceProfileDetectionsRequest.ReadOnly =
    zio.aws.macie2.model.UpdateResourceProfileDetectionsRequest
      .wrap(buildAwsValue())
}
object UpdateResourceProfileDetectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.UpdateResourceProfileDetectionsRequest =
      zio.aws.macie2.model.UpdateResourceProfileDetectionsRequest(
        resourceArn,
        suppressDataIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: __string
    def suppressDataIdentifiers
        : Optional[List[zio.aws.macie2.model.SuppressDataIdentifier.ReadOnly]]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getSuppressDataIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SuppressDataIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "suppressDataIdentifiers",
      suppressDataIdentifiers
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsRequest
  ) extends zio.aws.macie2.model.UpdateResourceProfileDetectionsRequest.ReadOnly {
    override val resourceArn: __string = impl.resourceArn(): __string
    override val suppressDataIdentifiers
        : Optional[List[zio.aws.macie2.model.SuppressDataIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressDataIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.SuppressDataIdentifier.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsRequest
  ): zio.aws.macie2.model.UpdateResourceProfileDetectionsRequest.ReadOnly =
    new Wrapper(impl)
}
