package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.JobStatus
  ): zio.aws.macie2.model.JobStatus = value match {
    case software.amazon.awssdk.services.macie2.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.JobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.macie2.model.JobStatus.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.macie2.model.JobStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.macie2.model.JobStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.macie2.model.JobStatus.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.macie2.model.JobStatus.USER_PAUSED =>
      val r = USER_PAUSED
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.RUNNING
  }
  case object PAUSED extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.PAUSED
  }
  case object CANCELLED extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.CANCELLED
  }
  case object COMPLETE extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.COMPLETE
  }
  case object IDLE extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.IDLE
  }
  case object USER_PAUSED extends zio.aws.macie2.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.JobStatus =
      software.amazon.awssdk.services.macie2.model.JobStatus.USER_PAUSED
  }
}
