package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait IsDefinedInJob {
  def unwrap: software.amazon.awssdk.services.macie2.model.IsDefinedInJob
}
object IsDefinedInJob {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.IsDefinedInJob
  ): zio.aws.macie2.model.IsDefinedInJob = value match {
    case software.amazon.awssdk.services.macie2.model.IsDefinedInJob.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.IsDefinedInJob.TRUE =>
      val r = TRUE
      r
    case software.amazon.awssdk.services.macie2.model.IsDefinedInJob.FALSE =>
      val r = FALSE
      r
    case software.amazon.awssdk.services.macie2.model.IsDefinedInJob.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.IsDefinedInJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsDefinedInJob =
      software.amazon.awssdk.services.macie2.model.IsDefinedInJob.UNKNOWN_TO_SDK_VERSION
  }
  case object TRUE extends zio.aws.macie2.model.IsDefinedInJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsDefinedInJob =
      software.amazon.awssdk.services.macie2.model.IsDefinedInJob.TRUE
  }
  case object FALSE extends zio.aws.macie2.model.IsDefinedInJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsDefinedInJob =
      software.amazon.awssdk.services.macie2.model.IsDefinedInJob.FALSE
  }
  case object UNKNOWN extends zio.aws.macie2.model.IsDefinedInJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsDefinedInJob =
      software.amazon.awssdk.services.macie2.model.IsDefinedInJob.UNKNOWN
  }
}
