package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFindingsResponse(
    findings: Optional[Iterable[zio.aws.macie2.model.Finding]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingsResponse = {
    import GetFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingsResponse
      .builder()
      .optionallyWith(
        findings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findings)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetFindingsResponse.ReadOnly =
    zio.aws.macie2.model.GetFindingsResponse.wrap(buildAwsValue())
}
object GetFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetFindingsResponse =
      zio.aws.macie2.model.GetFindingsResponse(
        findings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def findings: Optional[List[zio.aws.macie2.model.Finding.ReadOnly]]
    def getFindings
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Finding.ReadOnly]] =
      AwsError.unwrapOptionField("findings", findings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsResponse
  ) extends zio.aws.macie2.model.GetFindingsResponse.ReadOnly {
    override val findings
        : Optional[List[zio.aws.macie2.model.Finding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.Finding.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingsResponse
  ): zio.aws.macie2.model.GetFindingsResponse.ReadOnly = new Wrapper(impl)
}
