package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait FindingActionType {
  def unwrap: software.amazon.awssdk.services.macie2.model.FindingActionType
}
object FindingActionType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.FindingActionType
  ): zio.aws.macie2.model.FindingActionType = value match {
    case software.amazon.awssdk.services.macie2.model.FindingActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.FindingActionType.AWS_API_CALL =>
      val r = AWS_API_CALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.FindingActionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingActionType =
      software.amazon.awssdk.services.macie2.model.FindingActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_API_CALL extends zio.aws.macie2.model.FindingActionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingActionType =
      software.amazon.awssdk.services.macie2.model.FindingActionType.AWS_API_CALL
  }
}
