package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__integer, __boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateClassificationJobRequest(
    allowListIds: Optional[Iterable[__string]] = Optional.Absent,
    clientToken: __string,
    customDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    initialRun: Optional[__boolean] = Optional.Absent,
    jobType: zio.aws.macie2.model.JobType,
    managedDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent,
    managedDataIdentifierSelector: Optional[
      zio.aws.macie2.model.ManagedDataIdentifierSelector
    ] = Optional.Absent,
    name: __string,
    s3JobDefinition: zio.aws.macie2.model.S3JobDefinition,
    samplingPercentage: Optional[__integer] = Optional.Absent,
    scheduleFrequency: Optional[zio.aws.macie2.model.JobScheduleFrequency] =
      Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest = {
    import CreateClassificationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest
      .builder()
      .optionallyWith(
        allowListIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowListIds)
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(
        customDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.customDataIdentifierIds)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(initialRun.map(value => value: java.lang.Boolean))(
        _.initialRun
      )
      .jobType(jobType.unwrap)
      .optionallyWith(
        managedDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.managedDataIdentifierIds)
      .optionallyWith(managedDataIdentifierSelector.map(value => value.unwrap))(
        _.managedDataIdentifierSelector
      )
      .name(name: java.lang.String)
      .s3JobDefinition(s3JobDefinition.buildAwsValue())
      .optionallyWith(samplingPercentage.map(value => value: Integer))(
        _.samplingPercentage
      )
      .optionallyWith(scheduleFrequency.map(value => value.buildAwsValue()))(
        _.scheduleFrequency
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateClassificationJobRequest.ReadOnly =
    zio.aws.macie2.model.CreateClassificationJobRequest.wrap(buildAwsValue())
}
object CreateClassificationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateClassificationJobRequest =
      zio.aws.macie2.model.CreateClassificationJobRequest(
        allowListIds.map(value => value),
        clientToken,
        customDataIdentifierIds.map(value => value),
        description.map(value => value),
        initialRun.map(value => value),
        jobType,
        managedDataIdentifierIds.map(value => value),
        managedDataIdentifierSelector.map(value => value),
        name,
        s3JobDefinition.asEditable,
        samplingPercentage.map(value => value),
        scheduleFrequency.map(value => value.asEditable),
        tags.map(value => value)
      )
    def allowListIds: Optional[List[__string]]
    def clientToken: __string
    def customDataIdentifierIds: Optional[List[__string]]
    def description: Optional[__string]
    def initialRun: Optional[__boolean]
    def jobType: zio.aws.macie2.model.JobType
    def managedDataIdentifierIds: Optional[List[__string]]
    def managedDataIdentifierSelector
        : Optional[zio.aws.macie2.model.ManagedDataIdentifierSelector]
    def name: __string
    def s3JobDefinition: zio.aws.macie2.model.S3JobDefinition.ReadOnly
    def samplingPercentage: Optional[__integer]
    def scheduleFrequency
        : Optional[zio.aws.macie2.model.JobScheduleFrequency.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def getAllowListIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("allowListIds", allowListIds)
    def getClientToken: ZIO[Any, Nothing, __string] = ZIO.succeed(clientToken)
    def getCustomDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "customDataIdentifierIds",
        customDataIdentifierIds
      )
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getInitialRun: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("initialRun", initialRun)
    def getJobType: ZIO[Any, Nothing, zio.aws.macie2.model.JobType] =
      ZIO.succeed(jobType)
    def getManagedDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "managedDataIdentifierIds",
        managedDataIdentifierIds
      )
    def getManagedDataIdentifierSelector: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ManagedDataIdentifierSelector
    ] = AwsError.unwrapOptionField(
      "managedDataIdentifierSelector",
      managedDataIdentifierSelector
    )
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getS3JobDefinition
        : ZIO[Any, Nothing, zio.aws.macie2.model.S3JobDefinition.ReadOnly] =
      ZIO.succeed(s3JobDefinition)
    def getSamplingPercentage: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("samplingPercentage", samplingPercentage)
    def getScheduleFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.JobScheduleFrequency.ReadOnly
    ] = AwsError.unwrapOptionField("scheduleFrequency", scheduleFrequency)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest
  ) extends zio.aws.macie2.model.CreateClassificationJobRequest.ReadOnly {
    override val allowListIds: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowListIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val clientToken: __string = impl.clientToken(): __string
    override val customDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val initialRun: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.initialRun())
      .map(value => value: __boolean)
    override val jobType: zio.aws.macie2.model.JobType =
      zio.aws.macie2.model.JobType.wrap(impl.jobType())
    override val managedDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val managedDataIdentifierSelector
        : Optional[zio.aws.macie2.model.ManagedDataIdentifierSelector] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedDataIdentifierSelector())
        .map(value =>
          zio.aws.macie2.model.ManagedDataIdentifierSelector.wrap(value)
        )
    override val name: __string = impl.name(): __string
    override val s3JobDefinition
        : zio.aws.macie2.model.S3JobDefinition.ReadOnly =
      zio.aws.macie2.model.S3JobDefinition.wrap(impl.s3JobDefinition())
    override val samplingPercentage: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingPercentage())
      .map(value => value: __integer)
    override val scheduleFrequency
        : Optional[zio.aws.macie2.model.JobScheduleFrequency.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleFrequency())
        .map(value => zio.aws.macie2.model.JobScheduleFrequency.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest
  ): zio.aws.macie2.model.CreateClassificationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
