package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SensitivityInspectionTemplateIncludes(
    allowListIds: Optional[Iterable[__string]] = Optional.Absent,
    customDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent,
    managedDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes = {
    import SensitivityInspectionTemplateIncludes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes
      .builder()
      .optionallyWith(
        allowListIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowListIds)
      .optionallyWith(
        customDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.customDataIdentifierIds)
      .optionallyWith(
        managedDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.managedDataIdentifierIds)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly =
    zio.aws.macie2.model.SensitivityInspectionTemplateIncludes
      .wrap(buildAwsValue())
}
object SensitivityInspectionTemplateIncludes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SensitivityInspectionTemplateIncludes =
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes(
        allowListIds.map(value => value),
        customDataIdentifierIds.map(value => value),
        managedDataIdentifierIds.map(value => value)
      )
    def allowListIds: Optional[List[__string]]
    def customDataIdentifierIds: Optional[List[__string]]
    def managedDataIdentifierIds: Optional[List[__string]]
    def getAllowListIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("allowListIds", allowListIds)
    def getCustomDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "customDataIdentifierIds",
        customDataIdentifierIds
      )
    def getManagedDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "managedDataIdentifierIds",
        managedDataIdentifierIds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes
  ) extends zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly {
    override val allowListIds: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowListIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val customDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val managedDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes
  ): zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly =
    new Wrapper(impl)
}
