package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SensitivityInspectionTemplateExcludes(
    managedDataIdentifierIds: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes = {
    import SensitivityInspectionTemplateExcludes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes
      .builder()
      .optionallyWith(
        managedDataIdentifierIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.managedDataIdentifierIds)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly =
    zio.aws.macie2.model.SensitivityInspectionTemplateExcludes
      .wrap(buildAwsValue())
}
object SensitivityInspectionTemplateExcludes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SensitivityInspectionTemplateExcludes =
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes(
        managedDataIdentifierIds.map(value => value)
      )
    def managedDataIdentifierIds: Optional[List[__string]]
    def getManagedDataIdentifierIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "managedDataIdentifierIds",
        managedDataIdentifierIds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes
  ) extends zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly {
    override val managedDataIdentifierIds: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedDataIdentifierIds())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes
  ): zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly =
    new Wrapper(impl)
}
