package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSensitivityInspectionTemplatesResponse(
    nextToken: Optional[__string] = Optional.Absent,
    sensitivityInspectionTemplates: Optional[
      Iterable[zio.aws.macie2.model.SensitivityInspectionTemplatesEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse = {
    import ListSensitivityInspectionTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        sensitivityInspectionTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sensitivityInspectionTemplates)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse.ReadOnly =
    zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse
      .wrap(buildAwsValue())
}
object ListSensitivityInspectionTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse =
      zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse(
        nextToken.map(value => value),
        sensitivityInspectionTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def sensitivityInspectionTemplates: Optional[
      List[zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSensitivityInspectionTemplates: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sensitivityInspectionTemplates",
      sensitivityInspectionTemplates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse
  ) extends zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val sensitivityInspectionTemplates: Optional[
      List[zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitivityInspectionTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse
  ): zio.aws.macie2.model.ListSensitivityInspectionTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
