package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketCountBySharedAccessType(
    external: Optional[__long] = Optional.Absent,
    internal: Optional[__long] = Optional.Absent,
    notShared: Optional[__long] = Optional.Absent,
    unknown: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType = {
    import BucketCountBySharedAccessType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
      .builder()
      .optionallyWith(external.map(value => value: java.lang.Long))(_.external)
      .optionallyWith(internal.map(value => value: java.lang.Long))(_.internal)
      .optionallyWith(notShared.map(value => value: java.lang.Long))(
        _.notShared
      )
      .optionallyWith(unknown.map(value => value: java.lang.Long))(_.unknown)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly =
    zio.aws.macie2.model.BucketCountBySharedAccessType.wrap(buildAwsValue())
}
object BucketCountBySharedAccessType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketCountBySharedAccessType =
      zio.aws.macie2.model.BucketCountBySharedAccessType(
        external.map(value => value),
        internal.map(value => value),
        notShared.map(value => value),
        unknown.map(value => value)
      )
    def external: Optional[__long]
    def internal: Optional[__long]
    def notShared: Optional[__long]
    def unknown: Optional[__long]
    def getExternal: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("external", external)
    def getInternal: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("internal", internal)
    def getNotShared: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("notShared", notShared)
    def getUnknown: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unknown", unknown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
  ) extends zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly {
    override val external: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.external())
      .map(value => value: __long)
    override val internal: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.internal())
      .map(value => value: __long)
    override val notShared: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.notShared())
      .map(value => value: __long)
    override val unknown: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.unknown())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
  ): zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly = new Wrapper(
    impl
  )
}
