package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait AvailabilityCode {
  def unwrap: software.amazon.awssdk.services.macie2.model.AvailabilityCode
}
object AvailabilityCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AvailabilityCode
  ): zio.aws.macie2.model.AvailabilityCode = value match {
    case software.amazon.awssdk.services.macie2.model.AvailabilityCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AvailabilityCode.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.macie2.model.AvailabilityCode.UNAVAILABLE =>
      val r = UNAVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.AvailabilityCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AvailabilityCode =
      software.amazon.awssdk.services.macie2.model.AvailabilityCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.macie2.model.AvailabilityCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AvailabilityCode =
      software.amazon.awssdk.services.macie2.model.AvailabilityCode.AVAILABLE
  }
  case object UNAVAILABLE extends zio.aws.macie2.model.AvailabilityCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AvailabilityCode =
      software.amazon.awssdk.services.macie2.model.AvailabilityCode.UNAVAILABLE
  }
}
