package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchResourcesSortCriteria(
    attributeName: Optional[
      zio.aws.macie2.model.SearchResourcesSortAttributeName
    ] = Optional.Absent,
    orderBy: Optional[zio.aws.macie2.model.OrderBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesSortCriteria = {
    import SearchResourcesSortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesSortCriteria
      .builder()
      .optionallyWith(attributeName.map(value => value.unwrap))(_.attributeName)
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesSortCriteria.ReadOnly =
    zio.aws.macie2.model.SearchResourcesSortCriteria.wrap(buildAwsValue())
}
object SearchResourcesSortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesSortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesSortCriteria =
      zio.aws.macie2.model.SearchResourcesSortCriteria(
        attributeName.map(value => value),
        orderBy.map(value => value)
      )
    def attributeName
        : Optional[zio.aws.macie2.model.SearchResourcesSortAttributeName]
    def orderBy: Optional[zio.aws.macie2.model.OrderBy]
    def getAttributeName: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SearchResourcesSortAttributeName
    ] = AwsError.unwrapOptionField("attributeName", attributeName)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.macie2.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesSortCriteria
  ) extends zio.aws.macie2.model.SearchResourcesSortCriteria.ReadOnly {
    override val attributeName
        : Optional[zio.aws.macie2.model.SearchResourcesSortAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeName())
        .map(value =>
          zio.aws.macie2.model.SearchResourcesSortAttributeName.wrap(value)
        )
    override val orderBy: Optional[zio.aws.macie2.model.OrderBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderBy())
        .map(value => zio.aws.macie2.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesSortCriteria
  ): zio.aws.macie2.model.SearchResourcesSortCriteria.ReadOnly = new Wrapper(
    impl
  )
}
