package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAllowListsResponse(
    allowLists: Optional[Iterable[zio.aws.macie2.model.AllowListSummary]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListAllowListsResponse = {
    import ListAllowListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListAllowListsResponse
      .builder()
      .optionallyWith(
        allowLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowLists)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListAllowListsResponse.ReadOnly =
    zio.aws.macie2.model.ListAllowListsResponse.wrap(buildAwsValue())
}
object ListAllowListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListAllowListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListAllowListsResponse =
      zio.aws.macie2.model.ListAllowListsResponse(
        allowLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def allowLists
        : Optional[List[zio.aws.macie2.model.AllowListSummary.ReadOnly]]
    def nextToken: Optional[__string]
    def getAllowLists: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.AllowListSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("allowLists", allowLists)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListAllowListsResponse
  ) extends zio.aws.macie2.model.ListAllowListsResponse.ReadOnly {
    override val allowLists
        : Optional[List[zio.aws.macie2.model.AllowListSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.AllowListSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListAllowListsResponse
  ): zio.aws.macie2.model.ListAllowListsResponse.ReadOnly = new Wrapper(impl)
}
