package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FindingActor(
    domainDetails: Optional[zio.aws.macie2.model.DomainDetails] =
      Optional.Absent,
    ipAddressDetails: Optional[zio.aws.macie2.model.IpAddressDetails] =
      Optional.Absent,
    userIdentity: Optional[zio.aws.macie2.model.UserIdentity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.FindingActor = {
    import FindingActor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.FindingActor
      .builder()
      .optionallyWith(domainDetails.map(value => value.buildAwsValue()))(
        _.domainDetails
      )
      .optionallyWith(ipAddressDetails.map(value => value.buildAwsValue()))(
        _.ipAddressDetails
      )
      .optionallyWith(userIdentity.map(value => value.buildAwsValue()))(
        _.userIdentity
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.FindingActor.ReadOnly =
    zio.aws.macie2.model.FindingActor.wrap(buildAwsValue())
}
object FindingActor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.FindingActor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.FindingActor =
      zio.aws.macie2.model.FindingActor(
        domainDetails.map(value => value.asEditable),
        ipAddressDetails.map(value => value.asEditable),
        userIdentity.map(value => value.asEditable)
      )
    def domainDetails: Optional[zio.aws.macie2.model.DomainDetails.ReadOnly]
    def ipAddressDetails
        : Optional[zio.aws.macie2.model.IpAddressDetails.ReadOnly]
    def userIdentity: Optional[zio.aws.macie2.model.UserIdentity.ReadOnly]
    def getDomainDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.DomainDetails.ReadOnly] =
      AwsError.unwrapOptionField("domainDetails", domainDetails)
    def getIpAddressDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.IpAddressDetails.ReadOnly] =
      AwsError.unwrapOptionField("ipAddressDetails", ipAddressDetails)
    def getUserIdentity
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserIdentity.ReadOnly] =
      AwsError.unwrapOptionField("userIdentity", userIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.FindingActor
  ) extends zio.aws.macie2.model.FindingActor.ReadOnly {
    override val domainDetails
        : Optional[zio.aws.macie2.model.DomainDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainDetails())
        .map(value => zio.aws.macie2.model.DomainDetails.wrap(value))
    override val ipAddressDetails
        : Optional[zio.aws.macie2.model.IpAddressDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressDetails())
        .map(value => zio.aws.macie2.model.IpAddressDetails.wrap(value))
    override val userIdentity
        : Optional[zio.aws.macie2.model.UserIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userIdentity())
        .map(value => zio.aws.macie2.model.UserIdentity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.FindingActor
  ): zio.aws.macie2.model.FindingActor.ReadOnly = new Wrapper(impl)
}
