package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait SensitiveDataItemCategory {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory
}
object SensitiveDataItemCategory {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory
  ): zio.aws.macie2.model.SensitiveDataItemCategory = value match {
    case software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.FINANCIAL_INFORMATION =>
      val r = FINANCIAL_INFORMATION
      r
    case software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.PERSONAL_INFORMATION =>
      val r = PERSONAL_INFORMATION
      r
    case software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.CREDENTIALS =>
      val r = CREDENTIALS
      r
    case software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.CUSTOM_IDENTIFIER =>
      val r = CUSTOM_IDENTIFIER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.SensitiveDataItemCategory {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory =
      software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object FINANCIAL_INFORMATION
      extends zio.aws.macie2.model.SensitiveDataItemCategory {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory =
      software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.FINANCIAL_INFORMATION
  }
  case object PERSONAL_INFORMATION
      extends zio.aws.macie2.model.SensitiveDataItemCategory {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory =
      software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.PERSONAL_INFORMATION
  }
  case object CREDENTIALS
      extends zio.aws.macie2.model.SensitiveDataItemCategory {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory =
      software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.CREDENTIALS
  }
  case object CUSTOM_IDENTIFIER
      extends zio.aws.macie2.model.SensitiveDataItemCategory {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory =
      software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory.CUSTOM_IDENTIFIER
  }
}
