package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableMacieRequest(
    clientToken: Optional[__string] = Optional.Absent,
    findingPublishingFrequency: Optional[
      zio.aws.macie2.model.FindingPublishingFrequency
    ] = Optional.Absent,
    status: Optional[zio.aws.macie2.model.MacieStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.EnableMacieRequest = {
    import EnableMacieRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.EnableMacieRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.EnableMacieRequest.ReadOnly =
    zio.aws.macie2.model.EnableMacieRequest.wrap(buildAwsValue())
}
object EnableMacieRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.EnableMacieRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.EnableMacieRequest =
      zio.aws.macie2.model.EnableMacieRequest(
        clientToken.map(value => value),
        findingPublishingFrequency.map(value => value),
        status.map(value => value)
      )
    def clientToken: Optional[__string]
    def findingPublishingFrequency
        : Optional[zio.aws.macie2.model.FindingPublishingFrequency]
    def status: Optional[zio.aws.macie2.model.MacieStatus]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFindingPublishingFrequency
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingPublishingFrequency] =
      AwsError.unwrapOptionField(
        "findingPublishingFrequency",
        findingPublishingFrequency
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.macie2.model.MacieStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.EnableMacieRequest
  ) extends zio.aws.macie2.model.EnableMacieRequest.ReadOnly {
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
    override val findingPublishingFrequency
        : Optional[zio.aws.macie2.model.FindingPublishingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingPublishingFrequency())
        .map(value =>
          zio.aws.macie2.model.FindingPublishingFrequency.wrap(value)
        )
    override val status: Optional[zio.aws.macie2.model.MacieStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.macie2.model.MacieStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.EnableMacieRequest
  ): zio.aws.macie2.model.EnableMacieRequest.ReadOnly = new Wrapper(impl)
}
