package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceProfileArtifact(
    arn: __string,
    classificationResultStatus: __string,
    sensitive: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact = {
    import ResourceProfileArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact
      .builder()
      .arn(arn: java.lang.String)
      .classificationResultStatus(classificationResultStatus: java.lang.String)
      .optionallyWith(sensitive.map(value => value: java.lang.Boolean))(
        _.sensitive
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly =
    zio.aws.macie2.model.ResourceProfileArtifact.wrap(buildAwsValue())
}
object ResourceProfileArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ResourceProfileArtifact =
      zio.aws.macie2.model.ResourceProfileArtifact(
        arn,
        classificationResultStatus,
        sensitive.map(value => value)
      )
    def arn: __string
    def classificationResultStatus: __string
    def sensitive: Optional[__boolean]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getClassificationResultStatus: ZIO[Any, Nothing, __string] =
      ZIO.succeed(classificationResultStatus)
    def getSensitive: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("sensitive", sensitive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact
  ) extends zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val classificationResultStatus: __string =
      impl.classificationResultStatus(): __string
    override val sensitive: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitive())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact
  ): zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly = new Wrapper(impl)
}
