package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  ClassificationScopeName,
  ClassificationScopeId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetClassificationScopeResponse(
    id: Optional[ClassificationScopeId] = Optional.Absent,
    name: Optional[ClassificationScopeName] = Optional.Absent,
    s3: Optional[zio.aws.macie2.model.S3ClassificationScope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetClassificationScopeResponse = {
    import GetClassificationScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetClassificationScopeResponse
      .builder()
      .optionallyWith(
        id.map(value => ClassificationScopeId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          ClassificationScopeName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetClassificationScopeResponse.ReadOnly =
    zio.aws.macie2.model.GetClassificationScopeResponse.wrap(buildAwsValue())
}
object GetClassificationScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetClassificationScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetClassificationScopeResponse =
      zio.aws.macie2.model.GetClassificationScopeResponse(
        id.map(value => value),
        name.map(value => value),
        s3.map(value => value.asEditable)
      )
    def id: Optional[ClassificationScopeId]
    def name: Optional[ClassificationScopeName]
    def s3: Optional[zio.aws.macie2.model.S3ClassificationScope.ReadOnly]
    def getId: ZIO[Any, AwsError, ClassificationScopeId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ClassificationScopeName] =
      AwsError.unwrapOptionField("name", name)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.S3ClassificationScope.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetClassificationScopeResponse
  ) extends zio.aws.macie2.model.GetClassificationScopeResponse.ReadOnly {
    override val id: Optional[ClassificationScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.macie2.model.primitives.ClassificationScopeId(value)
      )
    override val name: Optional[ClassificationScopeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.macie2.model.primitives.ClassificationScopeName(value)
      )
    override val s3
        : Optional[zio.aws.macie2.model.S3ClassificationScope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.macie2.model.S3ClassificationScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetClassificationScopeResponse
  ): zio.aws.macie2.model.GetClassificationScopeResponse.ReadOnly = new Wrapper(
    impl
  )
}
