package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateClassificationScopeRequest(
    id: __string,
    s3: Optional[zio.aws.macie2.model.S3ClassificationScopeUpdate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeRequest = {
    import UpdateClassificationScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateClassificationScopeRequest.ReadOnly =
    zio.aws.macie2.model.UpdateClassificationScopeRequest.wrap(buildAwsValue())
}
object UpdateClassificationScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateClassificationScopeRequest =
      zio.aws.macie2.model
        .UpdateClassificationScopeRequest(id, s3.map(value => value.asEditable))
    def id: __string
    def s3: Optional[zio.aws.macie2.model.S3ClassificationScopeUpdate.ReadOnly]
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.S3ClassificationScopeUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeRequest
  ) extends zio.aws.macie2.model.UpdateClassificationScopeRequest.ReadOnly {
    override val id: __string = impl.id(): __string
    override val s3
        : Optional[zio.aws.macie2.model.S3ClassificationScopeUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value =>
          zio.aws.macie2.model.S3ClassificationScopeUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeRequest
  ): zio.aws.macie2.model.UpdateClassificationScopeRequest.ReadOnly =
    new Wrapper(impl)
}
