package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSensitiveDataOccurrencesAvailabilityResponse(
    code: Optional[zio.aws.macie2.model.AvailabilityCode] = Optional.Absent,
    reasons: Optional[Iterable[zio.aws.macie2.model.UnavailabilityReasonCode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse = {
    import GetSensitiveDataOccurrencesAvailabilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        reasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reasonsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly =
    zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
      .wrap(buildAwsValue())
}
object GetSensitiveDataOccurrencesAvailabilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse =
      zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse(
        code.map(value => value),
        reasons.map(value => value)
      )
    def code: Optional[zio.aws.macie2.model.AvailabilityCode]
    def reasons: Optional[List[zio.aws.macie2.model.UnavailabilityReasonCode]]
    def getCode: ZIO[Any, AwsError, zio.aws.macie2.model.AvailabilityCode] =
      AwsError.unwrapOptionField("code", code)
    def getReasons: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UnavailabilityReasonCode
    ]] = AwsError.unwrapOptionField("reasons", reasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
  ) extends zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly {
    override val code: Optional[zio.aws.macie2.model.AvailabilityCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.macie2.model.AvailabilityCode.wrap(value))
    override val reasons
        : Optional[List[zio.aws.macie2.model.UnavailabilityReasonCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UnavailabilityReasonCode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
  ): zio.aws.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse.ReadOnly =
    new Wrapper(impl)
}
