package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait TagTarget {
  def unwrap: software.amazon.awssdk.services.macie2.model.TagTarget
}
object TagTarget {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.TagTarget
  ): zio.aws.macie2.model.TagTarget = value match {
    case software.amazon.awssdk.services.macie2.model.TagTarget.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.TagTarget.S3_OBJECT =>
      val r = S3_OBJECT
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.TagTarget {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.TagTarget =
      software.amazon.awssdk.services.macie2.model.TagTarget.UNKNOWN_TO_SDK_VERSION
  }
  case object S3_OBJECT extends zio.aws.macie2.model.TagTarget {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.TagTarget =
      software.amazon.awssdk.services.macie2.model.TagTarget.S3_OBJECT
  }
}
