package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserIdentityRoot(
    accountId: Optional[__string] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    principalId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UserIdentityRoot = {
    import UserIdentityRoot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UserIdentityRoot
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UserIdentityRoot.ReadOnly =
    zio.aws.macie2.model.UserIdentityRoot.wrap(buildAwsValue())
}
object UserIdentityRoot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UserIdentityRoot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UserIdentityRoot =
      zio.aws.macie2.model.UserIdentityRoot(
        accountId.map(value => value),
        arn.map(value => value),
        principalId.map(value => value)
      )
    def accountId: Optional[__string]
    def arn: Optional[__string]
    def principalId: Optional[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UserIdentityRoot
  ) extends zio.aws.macie2.model.UserIdentityRoot.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val principalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UserIdentityRoot
  ): zio.aws.macie2.model.UserIdentityRoot.ReadOnly = new Wrapper(impl)
}
