package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait UsageType {
  def unwrap: software.amazon.awssdk.services.macie2.model.UsageType
}
object UsageType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.UsageType
  ): zio.aws.macie2.model.UsageType = value match {
    case software.amazon.awssdk.services.macie2.model.UsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.UsageType.DATA_INVENTORY_EVALUATION =>
      val r = DATA_INVENTORY_EVALUATION
      r
    case software.amazon.awssdk.services.macie2.model.UsageType.SENSITIVE_DATA_DISCOVERY =>
      val r = SENSITIVE_DATA_DISCOVERY
      r
    case software.amazon.awssdk.services.macie2.model.UsageType.AUTOMATED_SENSITIVE_DATA_DISCOVERY =>
      val r = AUTOMATED_SENSITIVE_DATA_DISCOVERY
      r
    case software.amazon.awssdk.services.macie2.model.UsageType.AUTOMATED_OBJECT_MONITORING =>
      val r = AUTOMATED_OBJECT_MONITORING
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageType =
      software.amazon.awssdk.services.macie2.model.UsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATA_INVENTORY_EVALUATION extends zio.aws.macie2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageType =
      software.amazon.awssdk.services.macie2.model.UsageType.DATA_INVENTORY_EVALUATION
  }
  case object SENSITIVE_DATA_DISCOVERY extends zio.aws.macie2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageType =
      software.amazon.awssdk.services.macie2.model.UsageType.SENSITIVE_DATA_DISCOVERY
  }
  case object AUTOMATED_SENSITIVE_DATA_DISCOVERY
      extends zio.aws.macie2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageType =
      software.amazon.awssdk.services.macie2.model.UsageType.AUTOMATED_SENSITIVE_DATA_DISCOVERY
  }
  case object AUTOMATED_OBJECT_MONITORING
      extends zio.aws.macie2.model.UsageType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageType =
      software.amazon.awssdk.services.macie2.model.UsageType.AUTOMATED_OBJECT_MONITORING
  }
}
