package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie2.model.primitives.S3BucketName
import scala.jdk.CollectionConverters._
final case class S3ClassificationScopeExclusion(
    bucketNames: Iterable[S3BucketName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusion = {
    import S3ClassificationScopeExclusion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusion
      .builder()
      .bucketNames(bucketNames.map { item =>
        S3BucketName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3ClassificationScopeExclusion.ReadOnly =
    zio.aws.macie2.model.S3ClassificationScopeExclusion.wrap(buildAwsValue())
}
object S3ClassificationScopeExclusion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3ClassificationScopeExclusion =
      zio.aws.macie2.model.S3ClassificationScopeExclusion(bucketNames)
    def bucketNames: List[S3BucketName]
    def getBucketNames: ZIO[Any, Nothing, List[S3BucketName]] =
      ZIO.succeed(bucketNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusion
  ) extends zio.aws.macie2.model.S3ClassificationScopeExclusion.ReadOnly {
    override val bucketNames: List[S3BucketName] = impl
      .bucketNames()
      .asScala
      .map { item =>
        zio.aws.macie2.model.primitives.S3BucketName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusion
  ): zio.aws.macie2.model.S3ClassificationScopeExclusion.ReadOnly = new Wrapper(
    impl
  )
}
