package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.__integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MonthlySchedule(
    dayOfMonth: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.MonthlySchedule = {
    import MonthlySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.MonthlySchedule
      .builder()
      .optionallyWith(dayOfMonth.map(value => value: Integer))(_.dayOfMonth)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.MonthlySchedule.ReadOnly =
    zio.aws.macie2.model.MonthlySchedule.wrap(buildAwsValue())
}
object MonthlySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.MonthlySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.MonthlySchedule =
      zio.aws.macie2.model.MonthlySchedule(dayOfMonth.map(value => value))
    def dayOfMonth: Optional[__integer]
    def getDayOfMonth: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.MonthlySchedule
  ) extends zio.aws.macie2.model.MonthlySchedule.ReadOnly {
    override val dayOfMonth: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.MonthlySchedule
  ): zio.aws.macie2.model.MonthlySchedule.ReadOnly = new Wrapper(impl)
}
