package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__stringMin1Max2048
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevealConfiguration(
    kmsKeyId: Optional[__stringMin1Max2048] = Optional.Absent,
    status: zio.aws.macie2.model.RevealStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.RevealConfiguration = {
    import RevealConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.RevealConfiguration
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.RevealConfiguration.ReadOnly =
    zio.aws.macie2.model.RevealConfiguration.wrap(buildAwsValue())
}
object RevealConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.RevealConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.RevealConfiguration =
      zio.aws.macie2.model
        .RevealConfiguration(kmsKeyId.map(value => value), status)
    def kmsKeyId: Optional[__stringMin1Max2048]
    def status: zio.aws.macie2.model.RevealStatus
    def getKmsKeyId: ZIO[Any, AwsError, __stringMin1Max2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getStatus: ZIO[Any, Nothing, zio.aws.macie2.model.RevealStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.RevealConfiguration
  ) extends zio.aws.macie2.model.RevealConfiguration.ReadOnly {
    override val kmsKeyId: Optional[__stringMin1Max2048] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: __stringMin1Max2048)
    override val status: zio.aws.macie2.model.RevealStatus =
      zio.aws.macie2.model.RevealStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.RevealConfiguration
  ): zio.aws.macie2.model.RevealConfiguration.ReadOnly = new Wrapper(impl)
}
