package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyDetails(
    action: Optional[zio.aws.macie2.model.FindingAction] = Optional.Absent,
    actor: Optional[zio.aws.macie2.model.FindingActor] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.PolicyDetails = {
    import PolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.PolicyDetails
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(actor.map(value => value.buildAwsValue()))(_.actor)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.PolicyDetails.ReadOnly =
    zio.aws.macie2.model.PolicyDetails.wrap(buildAwsValue())
}
object PolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.PolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.PolicyDetails =
      zio.aws.macie2.model.PolicyDetails(
        action.map(value => value.asEditable),
        actor.map(value => value.asEditable)
      )
    def action: Optional[zio.aws.macie2.model.FindingAction.ReadOnly]
    def actor: Optional[zio.aws.macie2.model.FindingActor.ReadOnly]
    def getAction
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getActor
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingActor.ReadOnly] =
      AwsError.unwrapOptionField("actor", actor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.PolicyDetails
  ) extends zio.aws.macie2.model.PolicyDetails.ReadOnly {
    override val action: Optional[zio.aws.macie2.model.FindingAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.macie2.model.FindingAction.wrap(value))
    override val actor: Optional[zio.aws.macie2.model.FindingActor.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actor())
        .map(value => zio.aws.macie2.model.FindingActor.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.PolicyDetails
  ): zio.aws.macie2.model.PolicyDetails.ReadOnly = new Wrapper(impl)
}
