package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, __integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFindingsRequest(
    findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria] =
      Optional.Absent,
    maxResults: Optional[__integer] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    sortCriteria: Optional[zio.aws.macie2.model.SortCriteria] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListFindingsRequest
      .builder()
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListFindingsRequest.ReadOnly =
    zio.aws.macie2.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListFindingsRequest =
      zio.aws.macie2.model.ListFindingsRequest(
        findingCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly]
    def maxResults: Optional[__integer]
    def nextToken: Optional[__string]
    def sortCriteria: Optional[zio.aws.macie2.model.SortCriteria.ReadOnly]
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsRequest
  ) extends zio.aws.macie2.model.ListFindingsRequest.ReadOnly {
    override val findingCriteria
        : Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.macie2.model.FindingCriteria.wrap(value))
    override val maxResults: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __integer)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val sortCriteria
        : Optional[zio.aws.macie2.model.SortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value => zio.aws.macie2.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsRequest
  ): zio.aws.macie2.model.ListFindingsRequest.ReadOnly = new Wrapper(impl)
}
