package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourceProfileDetectionsResponse(
    detections: Optional[Iterable[zio.aws.macie2.model.Detection]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse = {
    import ListResourceProfileDetectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse
      .builder()
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListResourceProfileDetectionsResponse.ReadOnly =
    zio.aws.macie2.model.ListResourceProfileDetectionsResponse
      .wrap(buildAwsValue())
}
object ListResourceProfileDetectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListResourceProfileDetectionsResponse =
      zio.aws.macie2.model.ListResourceProfileDetectionsResponse(
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def detections: Optional[List[zio.aws.macie2.model.Detection.ReadOnly]]
    def nextToken: Optional[__string]
    def getDetections
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Detection.ReadOnly]] =
      AwsError.unwrapOptionField("detections", detections)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse
  ) extends zio.aws.macie2.model.ListResourceProfileDetectionsResponse.ReadOnly {
    override val detections
        : Optional[List[zio.aws.macie2.model.Detection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.Detection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse
  ): zio.aws.macie2.model.ListResourceProfileDetectionsResponse.ReadOnly =
    new Wrapper(impl)
}
