package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListResourceProfileArtifactsRequest(
    nextToken: Optional[__string] = Optional.Absent,
    resourceArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest = {
    import ListResourceProfileArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListResourceProfileArtifactsRequest.ReadOnly =
    zio.aws.macie2.model.ListResourceProfileArtifactsRequest
      .wrap(buildAwsValue())
}
object ListResourceProfileArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListResourceProfileArtifactsRequest =
      zio.aws.macie2.model.ListResourceProfileArtifactsRequest(
        nextToken.map(value => value),
        resourceArn
      )
    def nextToken: Optional[__string]
    def resourceArn: __string
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest
  ) extends zio.aws.macie2.model.ListResourceProfileArtifactsRequest.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val resourceArn: __string = impl.resourceArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest
  ): zio.aws.macie2.model.ListResourceProfileArtifactsRequest.ReadOnly =
    new Wrapper(impl)
}
