package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOrganizationAdminAccountsResponse(
    adminAccounts: Optional[Iterable[zio.aws.macie2.model.AdminAccount]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse = {
    import ListOrganizationAdminAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
      .builder()
      .optionallyWith(
        adminAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adminAccounts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    zio.aws.macie2.model.ListOrganizationAdminAccountsResponse
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListOrganizationAdminAccountsResponse =
      zio.aws.macie2.model.ListOrganizationAdminAccountsResponse(
        adminAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def adminAccounts
        : Optional[List[zio.aws.macie2.model.AdminAccount.ReadOnly]]
    def nextToken: Optional[__string]
    def getAdminAccounts
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.AdminAccount.ReadOnly]] =
      AwsError.unwrapOptionField("adminAccounts", adminAccounts)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
  ) extends zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly {
    override val adminAccounts
        : Optional[List[zio.aws.macie2.model.AdminAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.AdminAccount.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse
  ): zio.aws.macie2.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
