package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSensitiveDataOccurrencesResponse(
    error: Optional[__string] = Optional.Absent,
    sensitiveDataOccurrences: Optional[
      Map[__string, Iterable[zio.aws.macie2.model.DetectedDataDetails]]
    ] = Optional.Absent,
    status: Optional[zio.aws.macie2.model.RevealRequestStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse = {
    import GetSensitiveDataOccurrencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse
      .builder()
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(
        sensitiveDataOccurrences.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.sensitiveDataOccurrences)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly =
    zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse
      .wrap(buildAwsValue())
}
object GetSensitiveDataOccurrencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse =
      zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse(
        error.map(value => value),
        sensitiveDataOccurrences.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        status.map(value => value)
      )
    def error: Optional[__string]
    def sensitiveDataOccurrences: Optional[
      Map[__string, List[zio.aws.macie2.model.DetectedDataDetails.ReadOnly]]
    ]
    def status: Optional[zio.aws.macie2.model.RevealRequestStatus]
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getSensitiveDataOccurrences: ZIO[Any, AwsError, Map[__string, List[
      zio.aws.macie2.model.DetectedDataDetails.ReadOnly
    ]]] = AwsError.unwrapOptionField(
      "sensitiveDataOccurrences",
      sensitiveDataOccurrences
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.RevealRequestStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse
  ) extends zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly {
    override val error: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: __string)
    override val sensitiveDataOccurrences: Optional[
      Map[__string, List[zio.aws.macie2.model.DetectedDataDetails.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitiveDataOccurrences())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> value.asScala.map { item =>
              zio.aws.macie2.model.DetectedDataDetails.wrap(item)
            }.toList
          })
          .toMap
      )
    override val status: Optional[zio.aws.macie2.model.RevealRequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.macie2.model.RevealRequestStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse
  ): zio.aws.macie2.model.GetSensitiveDataOccurrencesResponse.ReadOnly =
    new Wrapper(impl)
}
