package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetClassificationExportConfigurationResponse(
    configuration: Optional[
      zio.aws.macie2.model.ClassificationExportConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse = {
    import GetClassificationExportConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.GetClassificationExportConfigurationResponse
      .wrap(buildAwsValue())
}
object GetClassificationExportConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.GetClassificationExportConfigurationResponse =
      zio.aws.macie2.model.GetClassificationExportConfigurationResponse(
        configuration.map(value => value.asEditable)
      )
    def configuration: Optional[
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse
  ) extends zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly {
    override val configuration: Optional[
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.macie2.model.ClassificationExportConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse
  ): zio.aws.macie2.model.GetClassificationExportConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
