package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMembersRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    onlyAssociated: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListMembersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(onlyAssociated.map(value => value: java.lang.String))(
        _.onlyAssociated
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListMembersRequest.ReadOnly =
    zio.aws.macie2.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListMembersRequest =
      zio.aws.macie2.model.ListMembersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        onlyAssociated.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def onlyAssociated: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOnlyAssociated: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("onlyAssociated", onlyAssociated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListMembersRequest
  ) extends zio.aws.macie2.model.ListMembersRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val onlyAssociated: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.onlyAssociated())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListMembersRequest
  ): zio.aws.macie2.model.ListMembersRequest.ReadOnly = new Wrapper(impl)
}
