package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMemberRequest(
    account: zio.aws.macie2.model.AccountDetail,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateMemberRequest = {
    import CreateMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateMemberRequest
      .builder()
      .account(account.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateMemberRequest.ReadOnly =
    zio.aws.macie2.model.CreateMemberRequest.wrap(buildAwsValue())
}
object CreateMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateMemberRequest =
      zio.aws.macie2.model
        .CreateMemberRequest(account.asEditable, tags.map(value => value))
    def account: zio.aws.macie2.model.AccountDetail.ReadOnly
    def tags: Optional[Map[__string, __string]]
    def getAccount
        : ZIO[Any, Nothing, zio.aws.macie2.model.AccountDetail.ReadOnly] =
      ZIO.succeed(account)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateMemberRequest
  ) extends zio.aws.macie2.model.CreateMemberRequest.ReadOnly {
    override val account: zio.aws.macie2.model.AccountDetail.ReadOnly =
      zio.aws.macie2.model.AccountDetail.wrap(impl.account())
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateMemberRequest
  ): zio.aws.macie2.model.CreateMemberRequest.ReadOnly = new Wrapper(impl)
}
