package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait BucketMetadataErrorCode {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode
}
object BucketMetadataErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode
  ): zio.aws.macie2.model.BucketMetadataErrorCode = value match {
    case software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.BucketMetadataErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode =
      software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED
      extends zio.aws.macie2.model.BucketMetadataErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode =
      software.amazon.awssdk.services.macie2.model.BucketMetadataErrorCode.ACCESS_DENIED
  }
}
